############################################################################
#####################        function define     ###########################
############################################################################
library(amap)
error.bar <- function(x, y, upper, lower=upper, length=0.1,...){
  if(length(x) != length(y) | length(y) !=length(lower) | length(lower) != length(upper))
    stop("vectors must be same length")
  arrows(x,y+upper, x, y-lower, angle=90, code=3, length=length, ...)
}

cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")
############ 2nd naive RNAseq
logfpkm2nd <- read.table("../data/2nd.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
n_path <- c("hiF_r1","hiF_r2","he0_r1","he0_r2","he2_r1","he2_r2","he6_r1","he6_r2","n8_r1","n8_r2","n8_r3","n12_r1","n12_r2","n14_r1","n14_r2","n14_r3","n20_r1","n20_r2","n20_r3","n24p_r1","n24p_r2","n24m_r1","n24m_r2","niPS_r1","niPS_r2")
nData_tmp <- logfpkm2nd[,n_path]
nfpkm2nd <- 2**nData_tmp - 1

n_time_point <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24p","n24m","niPS")
n_label <- c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T")
nData2ndfpkm <- cbind(apply(nfpkm2nd[,1:2],1,mean),apply(nfpkm2nd[,3:4],1,mean),apply(nfpkm2nd[,5:6],1,mean),apply(nfpkm2nd[,7:8],1,mean),apply(nfpkm2nd[,9:11],1,mean),apply(nfpkm2nd[,12:13],1,mean),apply(nfpkm2nd[,14:16],1,mean),apply(nfpkm2nd[,17:19],1,mean),apply(nfpkm2nd[,20:21],1,mean),apply(nfpkm2nd[,22:23],1,mean),apply(nfpkm2nd[,24:25],1,mean))
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)
nData <- log2(nData2ndfpkm+1)
############ 2nd primed RNAseq
pData2ndfpkm <- read.table("../data/paper.primed.fpkm.txt",header=T,row.names=1)
pData <- log2(pData2ndfpkm+1)

common_time_point <- c("hiF-T","2d","6d","8d","14d","20d","24d+dox","24d-dox","niPSC-T/piPSC-T")

n_deg <- read.table("Gfold/cutoff.0.58/naive.2nd.deg")[,1]

###### development 
data <- read.table("../data/nsmb.2660-S2.txt",header=T,row.names=1)
Oocyte <- 1:3; Zygote <- 4:6; cell2 <- 7:12; cell4 <- 13:24; cell8 <- 25:44; Morula <- 45:60; 
MTE <- c(64,66,67,69,72,76:79);
PTE <- c(61:63,65,68,70,71,81,82);
# TE <- c(64,66,67,69,72,76:79,61:63,65,68,70,71,81,82);
PE <- c(84:90);
EPI <- c(73:75,80,83);
hESC0 <- 91:98; hESC10 <- 99:124
avg <- cbind(apply(data[,Oocyte],1,mean),apply(data[,Zygote],1,mean),apply(data[,cell2],1,mean),apply(data[,cell4],1,mean),apply(data[,cell8],1,mean),apply(data[,Morula],1,mean),apply(data[,MTE],1,mean),apply(data[,PTE],1,mean),apply(data[,PE],1,mean),apply(data[,EPI],1,mean),apply(data[,hESC0],1,mean),apply(data[,hESC10],1,mean))
time_point <- c("Oocyte","Zygote","X2cell","X4cell","X8cell","Morula","MTE","PTE","PE","EPI","hESC0","hESC10")
dev_labels <- c("Oocyte","Zygote","2cell","4cell","8cell","Morula","MTE","PTE","PE","EPI","hESC0","hESC10")
# avg <- cbind(apply(data[,Oocyte],1,mean),apply(data[,Zygote],1,mean),apply(data[,cell2],1,mean),apply(data[,cell4],1,mean),apply(data[,cell8],1,mean),apply(data[,Morula],1,mean),apply(data[,TE],1,mean),apply(data[,PE],1,mean),apply(data[,EPI],1,mean),apply(data[,hESC0],1,mean),apply(data[,hESC10],1,mean))
# time_point <- c("Oocyte","Zygote","X2cell","X4cell","X8cell","Morula","TE","PE","EPI","hESC0","hESC10")
# dev_labels <- c("Oocyte","Zygote","2cell","4cell","8cell","Morula","TE","PE","EPI","hESC0","hESC10")
colnames(avg) <- time_point
development_path <- time_point
dData <- log2(avg+1)


# normalise
library(edgeR)
genes <- intersect(row.names(nData),row.names(dData))
all_data <- cbind(nData[genes,n_time_point],dData[genes,time_point])
batch <- as.factor(c(rep(1,length(n_time_point)),rep(2,length(time_point))))
rmbatch_data <- removeBatchEffect(all_data,batch=batch)
nData <- rmbatch_data[genes,n_time_point]
dData <- rmbatch_data[genes,time_point]
nData[nData<0] = 0
dData[dData<0] = 0

############################################################################
#################    development.correlation.with.iPS   ####################
############################################################################

n_common_gene <- intersect(n_deg,intersect(rownames(dData),rownames(nData)))
n_cor <- c()
for (each_naive in n_time_point){
	tmp_cor <- c()
	for (each in rev(time_point)){
		tmp_cor <- c(tmp_cor,cor(dData[n_common_gene,each],nData[n_common_gene,each_naive]))
	}
	n_cor <- cbind(n_cor,tmp_cor)
}
rownames(n_cor) <- rev(time_point)
colnames(n_cor) <- n_time_point
plot_matrix <- n_cor

pdf("Fig2E.pdf",width=7,height=7)
all_exp <- c(as.matrix(plot_matrix))
zmax <- max(all_exp)
zmin <- min(all_exp)
par(oma=c(0.5,0.5,0.5,0.5),mar=c(1.5,5,2,1.5))
layout(matrix(c(1,1,1,1,1,1,1,1,1,2),nrow=10,ncol=1,byrow=F))
ColorRamp <- colorRampPalette(c("white",cccol[2]), bias=1)(100)   #color list
ColorLevels <- seq(to=zmax,from=zmin, length=100)   #number sequence
image(1:ncol(plot_matrix), 1:nrow(plot_matrix), t(plot_matrix), axes=F, col=ColorRamp, xlab="",ylab="")
axis(side=1,1:ncol(plot_matrix),labels=c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T"))
axis(side=2,1:nrow(plot_matrix),labels=rev(dev_labels),las=2)
# text(matrix(rep(1:ncol(plot_matrix),nrow(plot_matrix)),ncol=ncol(plot_matrix),nrow=nrow(plot_matrix),byrow = T), matrix(rep(1:nrow(plot_matrix),ncol(plot_matrix)),ncol=ncol(plot_matrix),nrow=nrow(plot_matrix)),as.matrix(round(plot_matrix,2)))
image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=1,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
dev.off()


############################################################################
#############             primed vs development         ####################
############################################################################
# normalise
p_time_point <- colnames(pData)
dData <- log2(avg+1)

library(edgeR)
genes <- intersect(row.names(pData),row.names(dData))
all_data <- cbind(pData[genes,p_time_point],dData[genes,time_point])
batch <- as.factor(c(rep(1,length(p_time_point)),rep(2,length(time_point))))
rmbatch_data <- removeBatchEffect(all_data,batch=batch)
pData <- rmbatch_data[genes,p_time_point]
dData <- rmbatch_data[genes,time_point]
pData[pData<0] = 0
dData[dData<0] = 0

############################################################################
#################   development.correlation.with.piPS   ####################
############################################################################

n_common_gene <- intersect(n_deg,intersect(rownames(dData),rownames(pData)))
n_cor <- c()
for (each_naive in p_time_point){
	tmp_cor <- c()
	for (each in rev(time_point)){
		tmp_cor <- c(tmp_cor,cor(dData[n_common_gene,each],pData[n_common_gene,each_naive]))
	}
	n_cor <- cbind(n_cor,tmp_cor)
}
rownames(n_cor) <- rev(time_point)
colnames(n_cor) <- p_time_point
plot_matrix <- n_cor

pdf("Fig2E_PrimedDevelopmentCorrelation.pdf",width=7,height=7)
all_exp <- c(as.matrix(plot_matrix))
zmax <- max(all_exp)
zmin <- min(all_exp)
par(oma=c(0.5,0.5,0.5,0.5),mar=c(1.5,5,2,1.5))
layout(matrix(c(1,1,1,1,1,1,1,1,1,2),nrow=10,ncol=1,byrow=F))
ColorRamp <- colorRampPalette(c("white",cccol[3]), bias=1)(100)   #color list
ColorLevels <- seq(to=zmax,from=zmin, length=100)   #number sequence
image(1:ncol(plot_matrix), 1:nrow(plot_matrix), t(plot_matrix), axes=F, col=ColorRamp, xlab="",ylab="")
axis(side=1,1:ncol(plot_matrix),labels=c("hiF-T","2d","5d","8d","10d","14d","20d","24d+dox","24d-dox","piPSC-T"))
axis(side=2,1:nrow(plot_matrix),labels=rev(dev_labels),las=2)
# text(matrix(rep(1:ncol(plot_matrix),nrow(plot_matrix)),ncol=ncol(plot_matrix),nrow=nrow(plot_matrix),byrow = T), matrix(rep(1:nrow(plot_matrix),ncol(plot_matrix)),ncol=ncol(plot_matrix),nrow=nrow(plot_matrix)),as.matrix(round(plot_matrix,2)))
image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=1,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
dev.off()